<?php 
/*
    PHPBoek(); Loginscript
    Copyright (C) 2015 Jasper Vries

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
	Alternatively, you may use this work under the terms of the
	Creative Commons Attribution-ShareAlike 3.0 Netherlands 
	(CC BY-SA 3.0 NL) license.
*/

//controleer of gebruiker is ingelogd
include('logincheck.inc.php');
//dit geeft tegelijkertijd het gebruikers-id in $user_id

//controleer of formulier verzonden
if (!empty($_POST)) {
	//controleer of nieuwe wachtwoorden gelijk
	if ($_POST['new_password1'] == $_POST['new_password2']) {
		//include database gegevens
		include('config.inc.php');
		//verbind met server
		$link = mysqli_connect($db['server'], $db['user'], $db['password'], $db['database']);
		//stel karakterset in voor mysqli_real_escape_string
		mysqli_set_charset($link, 'latin1');
		//bereken hash van oud wachtwoord
		$wachtwoord = hash('sha256', $_POST['old_password']);
		//query om rij te selecteren
		$sql = "SELECT
		`id`
		FROM `gebruikers`
		WHERE `id` = '" . mysqli_real_escape_string($link, $user_id) . "'
		AND `wachtwoord` = '" . mysqli_real_escape_string($link, $wachtwoord) . "'
		LIMIT 1";
		//voer query uit
		$result = mysqli_query($link, $sql);
		if (mysqli_num_rows($result) != 1) {
			//oud wachtwoord niet correct
			$oud_wachtwoord_fout = TRUE;
		}
		else {
			//wachtwoord correct, zet nieuw wachtwoord
			//bereken hash van nieuw wachtwoord
			$wachtwoord = hash('sha256', $_POST['new_password1']);
			//query om rij aan te passen
			$sql = "UPDATE `gebruikers`
			SET `wachtwoord` = '" . mysqli_real_escape_string($link, $wachtwoord) . "'
			WHERE `id` = '" . mysqli_real_escape_string($link, $user_id) . "'";
			//voer query uit
			$wachtwoord_gewijzigd = mysqli_query($link, $sql);
			//plaats cookie opnieuw om te voorkomen dat gebruiker uitgelogd is
			if ($wachtwoord_gewijzigd === TRUE) {
				$cookie['id'] = $user_id;
				$cookie['password'] = $wachtwoord; 
				//zet cookie
				setcookie('login', serialize($cookie), time() + 60*60*24*7*2, '/');
			}
		}
	}
	else {
		//nieuwe wachtwoorden niet gelijk
		$nieuw_wachtwoord_fout = TRUE;
	}
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Wijzig wachtwoord</title>
</head>
<body>

<h1>Wijzig wachtwoord</h1>

<?php
if ($nieuw_wachtwoord_fout === TRUE) {
    echo '<p class="error">De ingevulde nieuwe wachtwoorden zijn niet gelijk.</p>';
}
if ($oud_wachtwoord_fout === TRUE) {
    echo '<p class="error">De oude wachtwoord is niet juist.</p>';
}
if ($wachtwoord_gewijzigd === TRUE) {
    echo '<p class="succes">Wachtwoord gewijzigd!</p>';
}
?>

<form method="post">
<table>
<tr><td>Oud wachtwoord:</td><td><input type="password" name="old_password"></td></tr>
<tr><td>Nieuw wachtwoord:</td><td><input type="password" name="new_password1"></td></tr>
<tr><td>Herhaal wachtwoord:</td><td><input type="password" name="new_password2"></td></tr>
<tr><td></td><td><input type="submit" value="Wijzig wachtwoord"></td></tr>
</table>
</form>

</body>
</html> 